<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\AdminRole;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Utils\Helper;

class AdminRoleTransformer extends BaseTransformer
{
    use Macroable;
    protected $show_menu;
    public function __construct($show_menu = false)
    {
        $this->show_menu = $show_menu;
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="角色信息",
     *     type="object",
     *     schema="Role",
     *     @OA\Property(property="name", type="integer", description="名称"),
     *     @OA\Property(property="slug", type="string", description="描述"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */
    public function transform(AdminRole $role)
    {
        $return = ['name','slug','created_at'];
        $return = Helper::mapAttr($role,$return);
        if($this->show_menu){
            $return['menu_ids'] = array_column($role->menu->toArray(),'id');
        }

        return $return;
    }
}
