<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Admin\Http\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Admin\Entities\AdminMenu;
use Modules\Admin\Entities\AdminRole;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Utils\Helper;

class AdminMenuTransformer extends BaseTransformer
{
    use Macroable;
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="菜单信息",
     *     type="object",
     *     schema="Menu",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="parent_id", type="string", description="上级ID"),
     *     @OA\Property(property="title", type="string", description="标题"),
     *     @OA\Property(property="uri", type="string", description="uri"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     * )
     */

    public function transform(AdminMenu $menu)
    {

        $return = ['id','parent_id','title','uri','created_at'];

        return Helper::mapAttr($menu,$return);
    }
}
