<?php

namespace Modules\Admin\Http\Requests;

class MenuRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function postRules()
    {
        if(empty($this->parent_id)){
            $this['parent_id'] = 0;
            $parent_id_rule = [];
        }else{
            $parent_id_rule = ['exists:admin_menus,id'];
        }

        if(empty($this->uri)){
            $uri_rule = [];
        }else{
            $uri_rule = ['unique:admin_menus,uri'];
        }

        return [
            'parent_id' => $parent_id_rule,
            'title' => 'bail|required',
            'uri' => $uri_rule,
        ];
    }

    public function putRules()
    {
        if(empty($this->parent_id)){
            $this->parent_id = 0;
            $parent_id_rule = ['integer'];
        }else{
            $parent_id_rule = ['integer','exists:admin_menus,id'];
        }

        return [
            'parent_id' => $parent_id_rule,
            'title' => 'bail|required',
        ];
    }

    public function messages()
    {
        return [
            'title.required' => '菜单名称必须',
            'parent_id.exists' => '父菜单不存在',
            'uri.unique' => 'uri重复',
        ];
    }
}
