<?php

namespace Modules\Admin\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Dingo\Api\Facade\Route;
use Modules\Admin\Http\Utils\Helper;

class RoleMenu
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $user = auth()->user();
        #角色
        $role = $user->roles()->first();
        $menus = Helper::getRoleMenu($role);
        $role_uris = array_filter(array_column($menus,'uri'));
        $uris = array_filter(array_column(Helper::getAllMenu(),'uri'));

        $route = str_replace(".", "/", Route::currentRouteName());

        #验证菜单权限
        if(
            !Helper::isAdministrator($role->id)
            && in_array($route,$uris)
            && !in_array($route,$role_uris)
        ){
            abort(403,'没有权限');
        }

        return $next($request);
    }
}
