<?php

namespace Modules\Admin\Http\Requests;

use Illuminate\Validation\Rule;
use Modules\Admin\Entities\AdminUser;

class UserRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function postRules()
    {
        return [
            'username' => 'bail|required|unique:admin_users',
            'name' => 'bail|required',
            'role_id' => 'bail|required|exists:admin_roles,id',
        ];
    }

    public function putRules()
    {
        return [
            'username' => ['bail','required'],
            'name' => 'bail|required',
            'role_id' => 'bail|required|exists:admin_roles,id',
        ];
    }

    public function messages()
    {
        return [
            'username.required' => '用户名不能为空',
            'username.unique' => '用户名重复',
            'name.required' => '账号名称不能为空',
            'role_id.required' => '角色必须',
            'role_id.exists' => '角色不存在',
        ];
    }
}
