<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

$api = app('Dingo\Api\Routing\Router');
$api->version('v1', [
    'namespace' => 'Modules\Admin\Http\Controllers',
    'prefix'    => 'api',
], function ($api) {
    #登录
    $api->post('auth/login', 'AuthController@login');
    $api->group(['middleware' => 'api.auth'], function ($api) {
        #刷新token
        $api->get('auth/refresh', 'AuthController@refreshToken');
        #登出
        $api->put('auth/login_out', 'AuthController@loginOut');
        #配置
        $api->get('configs', 'AuthController@apiConfig');

        #菜单
        \Modules\Admin\Http\Utils\RouteRegister::registerApi($api,'menu','MenuController');

        #用户
        \Modules\Admin\Http\Utils\RouteRegister::registerApi($api,'user','UserController');

        #角色
        \Modules\Admin\Http\Utils\RouteRegister::registerApi($api,'role','RoleController');
        #角色权限
        $api->put('role/{id}/set_menu', 'RoleController@setRoleMenu');

    });

});
