<?php
declare(strict_types=1);

namespace Modules\Admin\Http\Utils;

use Illuminate\Support\Facades\Route;

class RouteRegister {
    public static function registerApi($api,$route, $controller) {
        #列表
        $api->get("{$route}/list", "{$controller}@list");
        #添加
        $api->post("{$route}/add", "{$controller}@add");
        #详情
        $api->get("{$route}/{id}/show", "{$controller}@detail");
        #编辑
        $api->put("{$route}/{id}/edit", "{$controller}@edit");
        #删除
        $api->delete("{$route}/{id}/delete", "{$controller}@delete");
    }
}
