<?php

namespace Modules\Admin\Http\Requests;

class MenuRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function postRules()
    {
        return [
            'parent_id' => 'integer|exists:admin_menus',
            'title' => 'bail|required',
        ];
    }

    public function messages()
    {
        return [
            'title.required' => '菜单名称必须',
            'parent_id.exists' => '父菜单不存在',
        ];
    }
}
