<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/21
 * @copyright
 */

namespace Modules\Admin\Http\Controllers;

use Dingo\Api\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Admin\Entities\AdminRoleUser;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Requests\UserRequest;
use Modules\Admin\Http\Transformers\AdminUserTransformer;
use Modules\Admin\Http\Utils\Helper;

class UserController extends BaseController
{
    public function list(){
        $list = AdminUser::all();
        return $this->response->collection($list,new AdminUserTransformer());
    }

    public function add(UserRequest $request){
        $params = $request->all(['username','password','name','avatar','role_id']);

        #默认密码
        if(empty($params['password'])){
            $params['password'] = '123456';
        }

        $params['salt'] = Helper::generateRandomString();
        $params['password'] = password_hash(md5($params['password'].$params['salt']), PASSWORD_DEFAULT);


        $user = DB::transaction(function () use ($params){
            $role_id = $params['role_id'];
            unset($params['role_id']);

            $user = AdminUser::create($params);

            AdminRoleUser::create(['role_id'=>$role_id,'user_id'=>$user->id]);

            return $user;
        });

        return $this->response->item($user,new AdminUserTransformer());
    }

    public function detail(){

    }

    public function edit(){

    }

    public function delete(){

    }
}