<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/21
 * @copyright
 */

namespace Modules\Admin\Http\Controllers;

use Dingo\Api\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Admin\Entities\AdminMenu;
use Modules\Admin\Entities\AdminRole;
use Modules\Admin\Entities\AdminRoleMenu;
use Modules\Admin\Http\Requests\RoleRequest;

class RoleController extends BaseController
{
    public function list(){

    }

    public function add(RoleRequest $request){
        $params = $request->all(['name','slug']);

        AdminRole::create($params);

        return $this->response->noContent()->statusCode(201);
    }

    public function detail(){

    }

    public function edit(){

    }

    public function delete(){

    }

    public function setRoleMenu(Request $request,$role_id){
        $params = $request->all(['menus']);
        if(!is_array($params['menus'])){
            abort(422,'格式错误');
        }

        if($role_id == 1){
            abort(500,'超级管理员不可编辑权限');
        }

        $menus = AdminMenu::all()->toArray();
        if($error = $this->checkMenu($menus,$params['menus'])){
            abort(500,$error);
        }

        DB::transaction(function () use ($params,$role_id){
            AdminRoleMenu::where('role_id',$role_id)->delete();

            $insert = [];
            foreach ($params['menus'] as $item){
                $insert[] = [
                    'role_id' => $role_id,
                    'menu_id' => (int)$item,
                ];
            }
            if($insert){
                AdminRoleMenu::insert($insert);
            }
        });

        return $this->response->noContent()->statusCode(204);
    }

    /**
     * 菜单格式是否正确
     * @desc
     *
     * @param $menus
     * @param $input_menu_ids
     *
     * @return string
     * @since     2023/10/21
     * @modify
     * @author    [ZZM]
     */
    function checkMenu($menus,$input_menu_ids){
        $menu_ids = array_column($menus,'id');
        $menu_parent_ids = array_column($menus,'parent_id','id');
        foreach ($input_menu_ids as $id){
            #不存在的菜单
            if(!in_array($id,$menu_ids)){
                return '包含不存在的菜单';
            }

            #选择了子菜单，但是没包含父级菜单
            $parent_id = $menu_parent_ids[$id];
            if($parent_id > 0 && !in_array($parent_id,$input_menu_ids)){
                return '未包含父级菜单';
            }
        }

        return '';
    }
}