<?php
/**
 * @desc
 * @author    [ZZM]
 * @since     2023/10/21
 * @copyright
 */

namespace Modules\Admin\Http\Controllers;

use Dingo\Api\Http\Request;
use Modules\Admin\Entities\AdminMenu;
use Modules\Admin\Http\Requests\MenuRequest;
use Modules\Admin\Http\Utils\Helper;

class MenuController extends BaseController
{
    public function list(){
        $menu = AdminMenu::all()->toArray();
        $menu = Helper::makeTree($menu);
        return $this->response->array(['data'=>$menu]);
    }

    public function add(MenuRequest $request){
        $params = $request->all(['title','uri','parent_id']);

        AdminMenu::create($params);

        return $this->response->noContent()->statusCode(201);
    }

    public function detail(){

    }

    public function edit(){

    }

    public function delete(){

    }

}