<?php

declare(strict_types=1);

namespace Modules\Admin\Http\Controllers;

use Exception;
use Dingo\Api\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Admin\Entities\AdminMenu;
use Modules\Admin\Entities\AdminUser;
use Modules\Admin\Http\Transformers\AccessTokenTransformer;
use Modules\Admin\Http\Transformers\BaseTransformer;
use Modules\Admin\Http\Utils\Helper;

class AuthController extends BaseController
{

    /**
     * 登录授权
     *
     * @param Request $request
     */
    public function login(Request $request)
    {
        $req      = $request->all();
        $username = $req["username"];
        $password = $req["password"];
        if ($username == "" || $password == "")
        {
            throw new \Exception("用户名或密码不能为空");
        }
        $user = AdminUser::where("username", $username)->first();
        if (!$user)
        {
            throw new \Exception("用户名或密码错误");
        }
        if (!password_verify(md5($password.$user->salt),$user->password))
        {
            throw new \Exception("用户名或密码错误");
        }

        return $this->response->item($user, new AccessTokenTransformer())->setStatusCode(201);
    }

    /**
     * 刷新token
     * @desc
     * @author    [ZZM]
     * @since     2023/10/21
     * @modify
     */
    public function refreshToken(){
        return $this->response->item($this->user, new AccessTokenTransformer(true))->setStatusCode(201);
    }

    /**
     * 登出
     * @desc
     * @author    [ZZM]
     * @since     2023/10/21
     * @modify
     */
    public function loginOut(){
        auth('api')->logout(true);
        return $this->response->noContent()->statusCode('204');
    }

    /**
     * 获取配置
     * @desc
     *
     * @param Request $request
     *
     * @return \Dingo\Api\Http\Response
     * @author    [ZZM]
     * @since     2023/10/21
     * @modify
     */
    public function apiConfig(Request $request)
    {
        $user  = $this->user;

        #角色
        $role = $user->roles()->first();
        if($role->id == 1){
            #超级管理员默认获取全部菜单
            $menu = AdminMenu::get();
        }else{
            #菜单
            $menu = $role->menu;
        }

        $menu = $menu->toArray();
        $menu = Helper::makeTree($menu);

        $data = [
            "menus"    => $menu,
        ];

        return $this->response->array(['data'=>$data]);
    }
}
