/**
 * 向后端请求用户的菜单，动态生成路由
 */
import { constantRouterMap } from '@/router'
import { generatorDynamicRouter } from '@/router/generator-routers'

const permission = {
  state: {
    routers: constantRouterMap,
    addRouters: [],
    menuSet: false
  },
  mutations: {
    SET_ROUTERS: (state, routers) => {
      state.addRouters = routers
      state.routers = constantRouterMap.concat(routers)
    },
    SET_MENU_SET: (state, flag) => {
      state.menuSet = flag
    }
  },
  actions: {
    GenerateRoutes({ commit }) {
      return new Promise((resolve, reject) => {
        generatorDynamicRouter().then(routers => {
          commit('SET_ROUTERS', routers)
          commit('SET_MENU_SET', true)
          resolve()
        }).catch(e => {
          reject(e)
        })
      })
    }
  }
}

export default permission
