import * as userService from '@/api/user'
import { constantRouterComponents } from '@/router/config'
import Layout from '@/layout'
import RouteView from '@/layout/RouteView'

// 前端未找到页面路由（固定不用改）
const notFoundRouter = {
  path: '*',
  redirect: '/404',
  hidden: true
}

// 根级菜单
const rootRouter = {
  router: '/',
  key: 'Root',
  component: Layout,
  redirect: '/dashboard',
  children: [{
    router: '/dashboard',
    key: 'Dashboard',
    title: '首页',
    icon: 'dashboard',
    component: () => import('@/views/dashboard/index')
  }]
}

/**
 * 动态生成菜单
 * @param token
 * @returns {Promise<Router>}
 */
export const generatorDynamicRouter = () => {
  return new Promise((resolve, reject) => {
    userService
      .getConfigs()
      .then(res => {
        const menus = res.data.menus
        const menuNav = []
        const childrenNav = []
        //      后端数据, 根级树数组,  根级 PID
        listToTree(menus, childrenNav, 0)
        rootRouter.children = [...rootRouter.children, ...childrenNav]
        menuNav.push(rootRouter)
        const routers = generator(menuNav)
        console.log(routers)
        // const routers = []
        routers.push(notFoundRouter)
        resolve(routers)
      })
      .catch(err => {
        reject(err)
      })
  })
}

/**
 * 格式化树形结构数据 生成 vue-router 层级路由表
 *
 * @param routerMap
 * @param parent
 * @returns {*}
 */
export const generator = (routerMap, parent) => {
  return routerMap.map(item => {
    // const { show, hideChildren, hiddenHeaderContent, target, icon } = item.meta || {}
    // const path = item.path || item.key + (item.id || '')
    const component = item.component || constantRouterComponents[item.key]
    const currentRouter = {
      // 如果路由设置了 path，则作为默认 path，否则 路由地址 动态拼接生成如 /dashboard/workplace
      path: item.router || (item.key + '_' + (item.id || '')),
      // 路由名称，建议唯一
      name: item.key + (item.id || ''),
      // 该路由对应页面的 组件 :方案1
      // component: constantRouterComponents[item.component || item.key],
      // 该路由对应页面的 组件 :方案2 (动态加载)
      component: component,
      // meta: 页面标题, 菜单图标, 页面权限(供指令权限用，可去掉)
      meta: {
        title: item.title,
        icon: item.icon
      }
    }
    // // 是否设置了隐藏菜单
    // if (show === false) {
    //   currentRouter.hidden = true
    // }
    // // 是否设置了隐藏子菜单
    // if (hideChildren) {
    //   currentRouter.hideChildrenInMenu = true
    // }
    // // 为了防止出现后端返回结果不规范，处理有可能出现拼接出两个 反斜杠
    // if (!currentRouter.path.startsWith('http')) {
    //   currentRouter.path = currentRouter.path.replace('//', '/')
    // }
    // 重定向
    item.redirect && (currentRouter.redirect = item.redirect)

    // 是否有子菜单，并递归处理
    if (item.children && item.children.length > 0) {
      // Recursion
      currentRouter.children = generator(item.children, currentRouter)
      if (item.key !== 'Root') {
        currentRouter.component = RouteView
      }
    }

    // 是否有功能页菜单
    // const actions = constantActionRouterComponents[item.key]
    // if (actions) {
    //   const children_action = generatorAction(actions, currentRouter)
    //   const children_menu = currentRouter.children || []
    //   console.log(children_action, children_menu)
    //   currentRouter.children = [...children_menu, ...children_action]
    // }

    return currentRouter
  })
}
export const generatorAction = (routerMap, parent) => {
  return routerMap.map(item => {
    return {
      path: item.path,
      name: parent.name + '.' + item.name,
      component: item.component,
      hidden: true,
      meta: {
        title: item.title,
        icon: item.icon,
        activeMenu: parent.path
      }
    }
  })
}

/**
 * 数组转树形结构
 * @param list 源数组
 * @param tree 树
 * @param parentId 父ID
 */
const listToTree = (list, tree, parentId) => {
  list.forEach(item => {
    // 判断是否为父级菜单
    if (item.parent_id === parentId) {
      const child = {
        ...item,
        // key: item.key || item.name,
        children: []
      }
      // 迭代 list， 找到当前菜单相符合的所有子菜单
      listToTree(list, child.children, item.id)
      // 删掉不存在 children 值的属性
      if (child.children.length <= 0) {
        delete child.children
      }
      // 加入到树中
      tree.push(child)
    }
  })
}
