import { Message } from 'element-ui'
import store from '../store'

export function listToTree(list, tree, parentId) {
  list.forEach(item => {
    // 判断是否为父级菜单
    if (item.parent_id === parentId) {
      const child = {
        ...item,
        // key: item.key || item.name,
        children: []
      }
      // 迭代 list， 找到当前菜单相符合的所有子菜单
      listToTree(list, child.children, item.id)
      // 删掉不存在 children 值的属性
      if (child.children.length <= 0) {
        delete child.children
      }
      // 加入到树中
      tree.push(child)
    }
  })
}

export function deepClone(source) {
  if (!source && typeof source !== 'object') {
    throw new Error('error arguments', 'deepClone')
  }
  const targetObj = source.constructor === Array ? [] : {}
  Object.keys(source).forEach(keys => {
    if (source[keys] && typeof source[keys] === 'object') {
      targetObj[keys] = deepClone(source[keys])
    } else {
      targetObj[keys] = source[keys]
    }
  })
  return targetObj
}

export function getRoleAction(menus, action, router) {
  const parentMatchedRoute = router.matched[router.matched.length - 2]
  const parent_name = parentMatchedRoute.name
  const role_action = []
  action.forEach((action) => {
    if (menus.find(item => item.key === parent_name + '.' + action)) {
      role_action.push(action)
    }
  })
  return role_action
}

export function checkRoleAction(action, role_action) {
  if (!store.getters.is_admin && !role_action.includes(action)) {
    Message.error('无权操作')
    return false
  }
  return true
}
