// 路由标识对应页面
export const constantRouterComponents = {
  // 权限管理
  'role.index': () => import('@/views/system/power/role/index'),
  'menu.index': () => import('@/views/system/power/menu/index'),

  // 员工管理
  'user.index': () => import('@/views/system/company/user/index'),
  'user.add': () => import('@/views/system/company/user/add'),
  'user.edit': () => import('@/views/system/company/user/edit'),

  // 部门管理
  'department.index': () => import('@/views/system/company/department/index'),

  // 公告管理
  'announcement.index': () => import('@/views/system/announcement/index'),

  // 客户-我的客户
  'private.index': () => import('@/views/customer/private/index'),
  'private.add': () => import('@/views/customer/private/add'),
  'private.edit': () => import('@/views/customer/private/edit'),
  'private.import': () => import('@/views/customer/private/import'),

  // 客户-公海客户
  'public.index': () => import('@/views/customer/public/index'),
  'public.add': () => import('@/views/customer/public/add'),
  'public.edit': () => import('@/views/customer/public/edit'),
  'public.import': () => import('@/views/customer/public/import'),

  // 客户-商机管理
  'opportunity.index': () => import('@/views/customer/opportunity/index'),
  'opportunity.add': () => import('@/views/customer/opportunity/add'),
  'opportunity.edit': () => import('@/views/customer/opportunity/edit')

}
