import request from '@/utils/request'

export function getList(params) {
  return request({
    url: '/customer/public/list',
    method: 'get',
    params
  })
}

export function getDetail(id, params) {
  return request({
    url: '/customer/public/' + id + '/show',
    method: 'get',
    params
  })
}

export function getOption(params) {
  return request({
    url: '/customer/public/data_maps',
    method: 'get',
    params
  })
}

export function addImport(params) {
  return request({
    url: '/customer/public/add_import',
    method: 'post',
    data: params
  })
}

export function addCustomer(params) {
  return request({
    url: '/customer/public/add',
    method: 'post',
    data: params
  })
}

export function editCustomer(id, params) {
  return request({
    url: '/customer/public/' + id + '/edit',
    method: 'put',
    data: params
  })
}

export function editCustomerPrivate(id, params) {
  return request({
    url: '/customer/public/' + id + '/edit_private',
    method: 'put',
    data: params
  })
}

export function receivePrivate(params) {
  return request({
    url: '/customer/public/receive_private',
    method: 'put',
    data: params
  })
}

export function followCustomer(id, params) {
  return request({
    url: '/customer/public/' + id + '/follow',
    method: 'put',
    data: params
  })
}

export function followList(id, params) {
  return request({
    url: '/customer/public/' + id + '/follow_list',
    method: 'get',
    params: params
  })
}

