import request from '@/utils/request'

export function getList(params) {
  return request({
    url: '/customer/private/list',
    method: 'get',
    params
  })
}

export function getDetail(id, params) {
  return request({
    url: '/customer/private/' + id + '/show',
    method: 'get',
    params
  })
}

export function getOption(params) {
  return request({
    url: '/customer/private/data_maps',
    method: 'get',
    params
  })
}

export function addImport(params) {
  return request({
    url: '/customer/private/add_import',
    method: 'post',
    data: params
  })
}

export function addCustomer(params) {
  return request({
    url: '/customer/private/add',
    method: 'post',
    data: params
  })
}

export function editCustomer(id, params) {
  return request({
    url: '/customer/private/' + id + '/edit',
    method: 'put',
    data: params
  })
}

export function editCustomerPrivate(id, params) {
  return request({
    url: '/customer/private/' + id + '/edit_private',
    method: 'put',
    data: params
  })
}

export function backPublic(params) {
  return request({
    url: '/customer/private/back_public',
    method: 'put',
    data: params
  })
}

export function followCustomer(id, params) {
  return request({
    url: '/customer/private/' + id + '/follow',
    method: 'put',
    data: params
  })
}

export function followList(id, params) {
  return request({
    url: '/customer/private/' + id + '/follow_list',
    method: 'get',
    params: params
  })
}

