import request from '@/utils/request'

export function getList(params) {
  return request({
    url: '/customer/opportunity/list',
    method: 'get',
    params
  })
}

export function getOption(params) {
  return request({
    url: '/customer/opportunity/data_maps',
    method: 'get',
    params
  })
}

export function getDetail(id, params) {
  return request({
    url: '/customer/opportunity/' + id + '/show',
    method: 'get',
    params
  })
}

export function addOpportunity(params) {
  return request({
    url: '/customer/opportunity/add',
    method: 'post',
    data: params
  })
}

export function editOpportunity(id, params) {
  return request({
    url: '/customer/opportunity/' + id + '/edit',
    method: 'put',
    data: params
  })
}
