import { constantRouterComponents } from '@/router/config'
import Layout from '@/layout'
import RouteView from '@/layout/RouteView'

// 前端未找到页面路由（固定不用改）
const notFoundRouter = {
  path: '*',
  redirect: '/404',
  hidden: true
}

// 根级菜单
const rootRouter = {
  path: '/',
  name: '/',
  component: Layout,
  redirect: '/dashboard',
  children: [{
    path: '/dashboard',
    name: 'dashboard',
    component: () => import('@/views/dashboard/index'),
    meta: {
      title: '首页',
      icon: 'dashboard'
    }
  }]
}

/**
 * 动态生成菜单
 * @param menus
 * @returns {Promise<Router>}
 */
export const generatorDynamicRouter = (menus) => {
  return new Promise((resolve, reject) => {
    const menuNav = []
    const childrenNav = []
    //      后端数据, 根级树数组,  根级 PID
    listToTree(menus, childrenNav, 0)
    const routers = generator(childrenNav)
    rootRouter.children = [...rootRouter.children, ...routers]
    menuNav.push(rootRouter)
    menuNav.push(notFoundRouter)
    resolve(menuNav)
  })
}

/**
 * 格式化树形结构数据 生成 vue-router 层级路由表
 *
 * @param routerMap
 * @param parent
 * @returns {*}
 */
export const generator = (routerMap, parent) => {
  return routerMap.map(item => {
    const currentRouter = {
      // 上级key + 自己key
      path: ((parent && parent.path) || '') + '/' + item.key,
      // 路由名称，建议唯一
      name: item.key,
      // 该路由对应页面的 组件 || 404
      component: constantRouterComponents[item.key] || (() => import('@/views/404')),
      // meta: 页面标题, 菜单图标
      meta: {
        title: item.title,
        icon: item.icon
      }
    }

    // 是否有子菜单，并递归处理
    if (item.children && item.children.length > 0) {
      // Recursion
      currentRouter.children = generator(item.children, currentRouter)

      currentRouter.component = RouteView
      currentRouter.redirect = 'noRedirect'
    }
    return currentRouter
  })
}

/**
 * 数组转树形结构
 * @param list 源数组
 * @param tree 树
 * @param parentId 父ID
 */
const listToTree = (list, tree, parentId) => {
  list.forEach(item => {
    // 判断是否为父级菜单
    if (item.parent_id === parentId) {
      const child = {
        ...item,
        // key: item.key || item.name,
        children: []
      }
      // 迭代 list， 找到当前菜单相符合的所有子菜单
      listToTree(list, child.children, item.id)
      // 删掉不存在 children 值的属性
      if (child.children.length <= 0) {
        delete child.children
      }
      // 加入到树中
      tree.push(child)
    }
  })
}
