import request from '@/utils/request'

export function login(data) {
  return request({
    url: '/auth/login',
    method: 'post',
    data
  })
}

export function getInfo(token) {
  return request({
    url: '/auth/info',
    method: 'get',
    params: { token }
  })
}

export function logout() {
  return request({
    url: '/auth/login_out',
    method: 'put'
  })
}

export function getConfigs() {
  return request({
    url: '/configs',
    method: 'get'
  })
}

export function userList(parameter) {
  return request({
    url: '/user/list',
    method: 'get',
    params: parameter
  })
}

export function userAdd(parameter) {
  return request({
    url: '/user/add',
    method: 'post',
    data: parameter
  })
}

export function userEdit(id, parameter) {
  return request({
    url: '/user/' + id + '/edit',
    method: 'put',
    data: parameter

  })
}

export function userDetail(id) {
  return request({
    url: '/user/' + id + '/detail',
    method: 'get'
  })
}

export function userDel(id) {
  return request({
    url: '/user/' + id + '/delete',
    method: 'delete'
  })
}

export function uploadFile(parameter) {
  return request({
    url: '/files',
    method: 'post',
    data: parameter

  })
}

