import request from '@/utils/request'

export function departmentList(parameter) {
  return request({
    url: '/department/list',
    method: 'get',
    params: parameter
  })
}

export function departmentDataList(parameter) {
  return request({
    url: '/department/data_list',
    method: 'get',
    params: parameter
  })
}

export function departmentAdd(parameter) {
  return request({
    url: '/department/add',
    method: 'post',
    data: parameter
  })
}

export function departmentEdit(id, parameter) {
  return request({
    url: '/department/' + id + '/edit',
    method: 'put',
    data: parameter

  })
}

export function departmentDetail(id) {
  return request({
    url: '/department/' + id + '/detail',
    method: 'get'
  })
}

export function departmentDel(id) {
  return request({
    url: '/department/' + id + '/delete',
    method: 'delete'
  })
}

