import request from '@/utils/request'

export function roleList(parameter) {
  return request({
    url: '/role/list',
    method: 'get',
    params: parameter
  })
}

export function roleDataList(parameter) {
  return request({
    url: '/role/data_list',
    method: 'get',
    params: parameter
  })
}

export function roleAdd(parameter) {
  return request({
    url: '/role/add',
    method: 'post',
    data: parameter
  })
}

export function roleEdit(id, parameter) {
  return request({
    url: '/role/' + id + '/edit',
    method: 'put',
    data: parameter

  })
}

export function roleDetail(id) {
  return request({
    url: '/role/' + id + '/detail',
    method: 'get'
  })
}

export function roleDel(id) {
  return request({
    url: '/role/' + id + '/delete',
    method: 'delete'
  })
}

