import request from '@/utils/request'

export function announcementList(parameter) {
  return request({
    url: '/announcement/list',
    method: 'get',
    params: parameter
  })
}

export function announcementAdd(parameter) {
  return request({
    url: '/announcement/add',
    method: 'post',
    data: parameter
  })
}

export function announcementEdit(id, parameter) {
  return request({
    url: '/announcement/' + id + '/edit',
    method: 'put',
    data: parameter

  })
}

export function announcementChange(id, parameter) {
  return request({
    url: '/announcement/' + id + '/change',
    method: 'put',
    data: parameter
  })
}

export function announcementDetail(id) {
  return request({
    url: '/announcement/' + id + '/detail',
    method: 'get'
  })
}

export function announcementDel(id) {
  return request({
    url: '/announcement/' + id + '/delete',
    method: 'delete'
  })
}

