<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('seller_home');
    }

    public function seller()
    {
        return view('seller_register');
    }

    public function store(Request $request)
    {
        $user = $request->user();

        throw_if($user->seller, '\Exception', '已经是商家或者申请正在审核中，不能再次申请');

        $request->validate(config('seller.store_rules', []));
        $user->seller()->create($request->all());

        return redirect()->route('home');
    }
}
