<?php
/**
 * Admin
 */
Route::group([
    'prefix' => config('admin.route.prefix'),
    'middleware' => config('admin.route.middleware'),
    'namespace' => 'Modules\Share\Http\Controllers\Admin',
], function ($router) {
    //方案管理curd
    $router->resource('scheme', 'SchemeController');
    //方案配置
    $router->get('scheme_config', 'SchemeController@config');


});

/**
 * api
 */
$api = app('Dingo\Api\Routing\Router');
$api->version(
    'v1',
    array_merge(
        [
            'namespace' => 'Modules\Share\Http\Controllers\Api',
            'prefix' => 'api/share',
        ],
        config('api.defaultSetting', [])
    ),
    function ($api) {

        // 方案列表
        $api->post('/schemes/list', 'SchemeController@index')
            ->name('api.share.scheme.store');

        // 新增方案
        $api->post('/schemes', 'SchemeController@create')
            ->name('api.share.scheme.create');

        // 查看方案详细信息
        $api->get('/schemes/{scheme_id}', 'SchemeController@show')
            ->name('api.share.scheme.show');

        // 修改方案
        $api->put('/schemes', 'SchemeController@edit')
            ->name('api.share.scheme.edit');

        // 启用/停用 方案
        $api->put('/schemes/status/{scheme_id}', 'SchemeController@status')
            ->name('api.share.scheme.status');

        // 删除方案
        $api->delete('/schemes/{scheme_id}', 'SchemeController@destroy')
            ->name('api.base.scheme.destroy');

        // 获取方案配置
        $api->get('/schemes_setting', 'SchemeController@showSetting')
            ->name('api.base.scheme.showSetting');

        // 修改方案配置
        $api->put('/schemes_setting', 'SchemeController@setting')
            ->name('api.base.scheme.setting');

    }
);
