<?php

namespace Modules\Share\Http\Controllers\Admin\Forms;

use Encore\Admin\Widgets\Form;
use Illuminate\Http\Request;
use Modules\Share\Entities\SchemeConfig;

class SchemeConfigSet extends Form
{
    /**
     * The form title.
     *
     * @var string
     */
    public $title = '方案统一配置';

    /**
     * Handle the form request.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request)
    {
        //dump($request->all());

        $SchemeConfig = SchemeConfig::first();
        $SchemeConfig->introduce_manager_ratio = $request->introduce_manager_ratio;
        $SchemeConfig->default_manager_ratio = $request->default_manager_ratio;
        $SchemeConfig->save();

        admin_success('设置成功');

        return back();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $this->number('introduce_manager_ratio','介绍掌柜奖励比例')->default(0)->rules('required|Numeric|between:0,100');
        $this->number('default_manager_ratio','默认奖励比例')->default(0)->rules('required|Numeric|between:0,100');
    }

    /**
     * The data of the form.
     *
     * @return array $data
     */
    public function data()
    {
        $SchemeConfig = SchemeConfig::first();


        return [
            'introduce_manager_ratio'    => $SchemeConfig->introduce_manager_ratio,
            'default_manager_ratio'      => $SchemeConfig->default_manager_ratio,
        ];
    }
}
