<?php

namespace Modules\Project\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;
use Modules\Project\Services\MacroService;

class ProjectServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');

        Event::listen('SMG\Mall\Events\OrderStatusChangeEvent', 'Modules\Project\Listeners\OrderStatusChangeListener');
        Event::listen('SMG\Pay\Events\PaymentSuccessEvent', 'Modules\Project\Listeners\PaymentSuccessListener');

        //添加一系列宏
        app(MacroService::class)->addMacro();

        $userClass = get_user_model();
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__.'/../Config/config.php' => config_path('project.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__.'/../Config/config.php', 'project'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {

        $viewPath = resource_path('views/modules/project');

        $sourcePath = __DIR__.'/../Resources/views';

        $this->publishes([
            $sourcePath => $viewPath
        ],'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/project';
        }, \Config::get('view.paths')), [$sourcePath]), 'project');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/project');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'project');
        } else {
            $this->loadTranslationsFrom(__DIR__ .'/../Resources/lang', 'project');
        }
    }

    /**
     * Register an additional directory of factories.
     *
     * @return void
     */
    public function registerFactories()
    {
        if (! app()->environment('production')) {
            app(Factory::class)->load(__DIR__ . '/../Database/factories');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
