<?php

/*
 * admin
 */
Route::group([
    'prefix' => config('admin.route.prefix'),
    'middleware' => config('admin.route.middleware'),
    'namespace' => 'Modules\Project\Http\Controllers\Admin',
], function ($router) {
    $router->resource('user', 'UserController');
    //会员
    $router->get('/user/org/{user_id}', 'UserController@org');

    //资产
    $router->get('/wallet', 'WalletController@index');
    //入金日志
    $router->get('/wallet/money_log', 'WalletController@moneyLog');
    $router->get('/wallet/admin_money_log', 'WalletController@adminMoneyLog');

    //修改积分
    $router->get('/wallet/add_point', 'WalletController@addPoint');
    $router->post('/wallet/add_point', 'WalletController@addPoint');

    //设置支付密码
    $router->get('/wallet/password', 'WalletController@password');
    $router->post('/wallet/password', 'WalletController@password');
    //__AUTO_INSERT_ADMIN_ROUTE_PLACE__
});


$api = app('Dingo\Api\Routing\Router');
$api->version(
    'v1',
    array_merge(
        [
            'namespace' => 'Modules\Project\Http\Controllers\Api',
            'prefix' => 'api',
        ],
        config('api.defaultSetting', [])
    ),
    function ($api) {

        //公共配置信息
        $api->get('configs', 'ConfigController@index')->name('api.configs');

        //__AUTO_INSERT_API_ROUTE_PLACE__

        // 需要 token 验证的接口
        $api->group(['middleware' => 'api.auth'], function ($api) {
            //__AUTO_INSERT_AUTH_API_ROUTE_PLACE__
        });

    }
);