<?php

/**
 * API START!
 *
 * @author syw
 *
 * @OA\OpenApi(
 *     @OA\Info(
 *         version="1.0.0",
 *         title="接口",
 *         description="<b>通用状态码</b>：
 *     200 成功
 *     201 成功创建
 *     204 执行成功，没有返回内容
 *
 *     401 没有登陆
 *     403 没有权限
 *     404 要操作的资源不存在
 *     405 操作方法不允许
 *     422 参数验证错误
 *     500 程序出现错误
 *",
 *     )
 * )
 */

/**
 * @OA\SecurityScheme(
 *      securityScheme="jwt_auth",
 *      type="http",
 *      scheme="bearer",
 *      bearerFormat="JWT",
 * )
 *
 * @OA\Get(
 *     tags={"基础接口"},
 *     summary="获取验证码",
 *     path="/api/captcha",
 *     @OA\Response(
 *      response="200",
 *      description="验证码信息",
 *      @OA\MediaType(
 *          mediaType="application/json",
 *          @OA\Schema(
 *                 type="object",
 *                 @OA\Property(property="data", type="object", ref="#/components/schemas/Verify")
 *         )
 *      )
 *     )
 * )
 *
 *
 *  @OA\Get(
 *     tags={"基础接口"},
 *     summary="缩略图",
 *     path="/imagecache/{template}/{image_path}",
 *     @OA\Parameter(
 *         name="template",
 *         in="path",
 *         description="图片处理模板，默认有 small,medium,large三种",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *         )
 *     ),
 *     @OA\Parameter(
 *         name="image_path",
 *         in="path",
 *         description="储存的文件名，程序保存时的路径",
 *         required=true,
 *         @OA\Schema(
 *             type="string",
 *         )
 *     ),
 *     @OA\Response(
 *      response="200",
 *      description="处理后的图片",
 *      @OA\MediaType(
 *          mediaType="image/png",
 *          @OA\Schema(
 *                 type="string",
 *                 format="binary",
 *         )
 *      ),
 *      @OA\MediaType(
 *          mediaType="image/jpg",
 *          @OA\Schema(
 *                 type="string",
 *                 format="binary",
 *         )
 *      ),
 *      @OA\MediaType(
 *          mediaType="image/jpeg",
 *          @OA\Schema(
 *                 type="string",
 *                 format="binary",
 *         )
 *      ),
 *      @OA\MediaType(
 *          mediaType="image/gif",
 *          @OA\Schema(
 *                 type="string",
 *                 format="binary",
 *         )
 *      )
 *     )
 * )
 *
 * @OA\Schema(
 *     description="请求验证错误422",
 *     type="object",
 *     schema="error422",
 *     @OA\Property(property="message", type="string", description="422 Unprocessable Entity"),
 *     @OA\Property(property="error", type="object", description="错误",
 *          @OA\Property(property="key", type="array", description="请求键值",
 *              @OA\Items(type="string", description="具体错误"),
 *          ),
 *     ),
 *     @OA\Property(property="status_code", type="integer", description="状态码422", example=422),
 *     @OA\Property(property="debug", type="object", description="错误调试信息")
 * )
 *
 *
 *
 *  @OA\Schema(
 *     description="验证码信息",
 *     type="object",
 *     schema="Verify",
 *     @OA\Property(property="sensitive", type="boolean", description="验证码是否大小写敏感"),
 *     @OA\Property(property="key", type="string", description="验证码KEY"),
 *     @OA\Property(property="img", type="string", description="验证码图片(base64图片编码)")
 * )
 *
 * @OA\Schema(
 *     description="手机号",
 *     type="string",
 *     schema="phone",
 *     minLength=11
 * )
 *
 * @OA\Schema(
 *     description="密码",
 *     type="string",
 *     schema="password",
 *     minLength=6
 * )
 *
 * @OA\Schema(
 *     description="手机短信验证码",
 *     type="string",
 *     schema="phone_code",
 *     minLength=4
 * )
 *
 * @OA\Schema(
 *     description="邮箱",
 *     type="string",
 *     schema="email"
 * )
 *
 * @OA\Schema(
 *     description="1为是，0为否",
 *     type="integer",
 *     enum={0,1},
 *     schema="yesno"
 * )
 *
 * @OA\Schema(
 *     description="验证码KEY",
 *     type="string",
 *     schema="captcha_key"
 * )
 *
 * @OA\Schema(
 *     description="验证码",
 *     type="string",
 *     schema="captcha_code"
 * )
 */