<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2019/10/11
 * Time: 12:01
 * 
 * 使用方式，请在 AppServiceProvider 里面的 register 方法添加  
    $this->app->extend(\Illuminate\Config\Repository::class, function ($config){
       return new \Modules\Base\Services\ConfigExtendService($config);
    });
 */
namespace Modules\Base\Services;

use Illuminate\Config\Repository;

class ConfigExtendService extends Repository
{
    protected $config;

    public function __construct($config)
    {
        $this->config = $config;
    }

    public function has($key)
    {
        return $this->config->has($key);
    }

    public function get($key, $default = null)
    {
        if (is_array($key)) {
            return $this->getMany($key);
        }

        //$keys = explode('.', $key);
        /*
        $maps = $this->config->get('config_from_setting', []);

        if (isset($maps[$key])) {
            return \SMG\Support\Setting\Setting::get($maps[$key], $default);
        }
        */


        /*
        if (isset($maps[$keys[0]])) {
            if (is_string($maps[$keys]))
            $keys[0] = $maps[$keys[0]];
            $key = implode('.', $maps);

            return \SMG\Support\Setting\Setting::get($key, $default);
        }
        */

        if ($key == 'mall.product.use_score_percent.default') {
            return nf(\SMG\Support\Setting\Setting::get('common.maximum_point_deduction_percentage', $default)/100, 4);
        }

        return $this->config->get($key, $default);
    }

    public function all()
    {
        return $this->config->all();
    }

    public function set($key, $value = null)
    {
        return $this->config->set($key, $value);
    }

    public function prepend($key, $value)
    {
        return $this->config->prepend($key, $value);
    }

    public function push($key, $value)
    {
        return $this->config->push($key, $value);
    }

    public function offsetExists($offset)
    {
        return $this->config->offsetExists($offset);
    }

    public function offsetGet($offset)
    {
        return $this->config->offsetGet($offset);
    }

    public function offsetSet($offset, $value)
    {
        return $this->config->offsetSet($offset, $value);
    }

    public function offsetUnset($offset)
    {
        return $this->config->offsetUnset($offset);
    }

    public function getMaps()
    {
        static $map;

        if ($map === null) {
            $map = $this->config->get('config_from_setting', []);
        }
    }

    public function __call($name, $arguments)
    {
        return $this->config->$name(...$arguments);
    }
}
