<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/11/10
 * Time: 16:01
 */
namespace Modules\Base\Http\Controllers;

use Modules\Base\Entities\User;
use Modules\Base\Services\NewOpenloginService;
use Modules\Base\Services\OpenloginService;

class UserController
{
    /**
     * 微信公众号登陆(如果已经登陆则绑定 )
     *
     * @param NewOpenloginService $openloginService
     *
     * @throws \Throwable
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function wechatLogin(NewOpenloginService $openloginService)
    {
        $info = session('wechat.oauth_user.default');

        $user = auth('api')->user();

        $user = $openloginService->login('weixin', $info->original, $user);

        $token = \Auth::guard('api')->setTTL(1)->login($user); //安全起见，只一分钟有效
        $url = request('back_url', '/h5/#/login_from_token?redirect=%2Fuser').'&token='.$token;

        //清除SESSION，不然换账号登陆会是同一个
        session()->forget('wechat.oauth_user.default');

        return redirect($url);
    }

    /**
     * @param NewOpenloginService $openloginService
     *
     * @throws \Throwable
     */
    public function wechatTest(NewOpenloginService $openloginService)
    {
        $info = session('wechat.oauth_user.default');

        dump($info->original);

        try {
            $user = $openloginService->login('weixin', $info->original);
            dd($user);
        } catch (\Exception $e) {
            dd($e);
        }

        dd($info);
    }

    /**
     * @param NewOpenloginService $openloginService
     *
     * @throws \Throwable
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function wechatBind(NewOpenloginService $openloginService)
    {
        $user = auth('api')->user();
        $back_url = request('back_url', '/h5');
        logger('开始绑定微信');
        logger('当前用户');
        logger($user);
        if ($user && !$user->openid) {
            $info = session('wechat.oauth_user.default');
            logger('微信信息');
            logger($info->original);

            $user = $openloginService->login('weixin', $info->original, $user);

            logger('绑定后用户信息');
            logger($user);
        }

        return redirect($back_url);
    }

    /**
     * @param NewOpenloginService $openloginService
     *
     * @throws \Throwable
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function wechatLoginTest(NewOpenloginService $openloginService)
    {
        $info = session('wechat.oauth_user.default');

        dump($info);

        $user = $openloginService->login('weixin', $info);

        dd($user);

        //dd($info);
        //$info = (object) session('wechat.oauth_user.default');

        $user = User::orderBy('id', 'DESC')->first();
        $token = \Auth::guard('api')->setTTL(1)->login($user); //安全起见，只一分钟有效
        $url = request('back_url', '/wap/#/login_from_token?redirect=%2Fuser').'&token='.$token;

        return redirect($url);
    }

    public function clean()
    {
        session()->forget('wechat.oauth_user.default');

        return 'success';
    }
}
