<?php

namespace Modules\Share\Http\Controllers\Admin;

use Encore\Admin\Layout\Content;
use Modules\Share\Entities\Scheme;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use SMG\Admin\Grid;
use Encore\Admin\Show;
use Modules\Share\Http\Controllers\Admin\Forms\SchemeConfigSet;

class SchemeController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = '方案管理';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Scheme());

        $grid->column('id', 'Id');
        $grid->column('name', '名称');
        $grid->column('direct_source_ratio', '直接客源奖励比例');
        $grid->column('indirect_source_ratio', '间接客源奖励比例');
        $grid->column('recharge_amount', '充值金额');
        $grid->column('consume_amount', '可消费充值金额');
        $grid->column('unconsume_amount', '不可消费充值金额');
        $grid->column('online_pay', '是否线上支付')->display(function ($v) {
            return $v == 1 ?'是':'否';
        });
        $grid->column('dividend_type', '分红方式')->display(function ($v) {
            return $v == 1 ?'毛利分红':'实收分红';
        });
        $grid->column('benefit_month', '受益时长')->display(function ($v) {
            return $v .'个月';
        });
        $grid->column('status', '是否启用')->display(function ($v) {
            return $v == 1 ?'启用':'禁用';
        });
        $grid->column('created_at', '创建时间');

        $grid->filter(function ($filter) {
            $filter->like('name', '方案名称');
            $filter->equal('dividend_type','分红方式')->select([1 => '毛利分红',2 => '实收分红']);
            $filter->equal('status','状态')->radio([
                ''   => '全部',
                0    => '禁用',
                1    => '启用',
            ]);
        });
        $grid->enableFilter();

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Scheme::findOrFail($id));

        $show->field('id', 'Id');
        $show->field('name', '名称');
        $show->field('direct_source_ratio', '直接客源奖励比例');
        $show->field('indirect_source_ratio', '间接客源奖励比例');
        $show->field('recharge_amount', '充值金额');
        $show->field('consume_amount', '可消费充值金额');
        $show->field('unconsume_amount', '不可消费充值金额');
        $show->field('online_pay', '是否线上支付')->as(function ($v) {
            return $v == 1 ?'是':'否';
        });
        $show->field('dividend_type', '分红方式')->as(function ($v) {
            return $v == 1 ?'毛利分红':'实收分红';
        });
        $show->field('benefit_month', '受益时长')->as(function ($v) {
            return $v .'个月';
        });
        $show->field('status', '是否启用')->as(function ($v) {
            return $v == 1 ?'启用':'禁用';
        });
        $show->field('status', '是否启用');

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Scheme());

        $form->text('name', '名称')->rules('required');
        $form->number('direct_source_ratio', '直接客源奖励比例')->rules('required|Numeric|between:0,100');
        $form->number('indirect_source_ratio', '间接客源奖励比例')->rules('required|Numeric|between:0,100');
        $form->decimal('recharge_amount', '充值金额')->rules('required|Numeric|between:1,99999999');
        $form->decimal('consume_amount', '可消费充值金额')->rules('required|Numeric|between:1,99999999');
        $form->decimal('unconsume_amount', '不可消费充值金额')->rules('required|Numeric|between:1,99999999');
        $form->switch('online_pay', '线上支付')->default(1)->rules('required');
        $form->select('dividend_type', '分红方式')->options([1 => '毛利分红', 2 => '实收分红'])->rules('required');
        $form->number('benefit_month', '受益时长/个月')->rules('required');
        $form->switch('status', '是否启用')->default(1)->rules('required');

        return $form;
    }

    public function config(Content $content)
    {
        return $content
            ->title('方案配置')
            ->body(new SchemeConfigSet());
    }
}
