<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Base\Transformers;

use Illuminate\Notifications\DatabaseNotification;

class NotificationTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="通知信息",
     *     type="object",
     *     schema="Notification",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="type", type="string", description="通知类型"),
     *     @OA\Property(property="data", type="object", description="通知数据"),
     *     @OA\Property(property="read_at", type="string", description="查看时间"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(DatabaseNotification $notification)
    {
        return map_attr($notification, ['id', 'type', 'data', 'read_at', 'created_at', 'updated_at']);
    }
}
