<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2019/10/12
 * Time: 10:33
 */

namespace Modules\Base\Services\Exception;


use Throwable;

class DisplayException extends \Exception
{
    public  $disable_return = false;
    public $page_title = '错误';

    public function __construct(string $message = "", int $code = 0, Throwable $previous = null, $disable_return = false, $title = '错误')
    {
        parent::__construct($message, $code, $previous);

        $this->disable_return = $disable_return;
        $this->page_title = $title;
    }

    public function render()
    {
        $agent = $_SERVER['HTTP_USER_AGENT'] ?? '';

        if (strpos($agent, 'okhttp')!==false || strpos($agent, 'bai bian shang cheng')!== false) {
            $is_app = true;
        } else {
            $is_app = false;
        }

        return view('base::display_error', ['error'=>$this]);
    }

    public function report()
    {
        return null;
    }

    public static function throwIf($condition, $message, $disable_return = false, $title = '错误')
    {
        if ($condition) {
            throw new static($message, 0, null, $disable_return, $title);
        }

        return true;
    }

    public static function throw($message, $disable_return = false, $title = '错误')
    {
        throw new static($message, 0, null, $disable_return, $title);
    }
}