<?php

namespace Modules\Base\Http\Controllers;

use Illuminate\Routing\Controller;
use Modules\Base\Entities\User;

class UserAvatarController extends Controller
{
    public function avatar($user)
    {
        $user = User::find($user);
        $avatar = $user ? $user->avatar : null;
        if (!$avatar) {
            $avatar = '/image/default_avatar.jpg';
        }

        if (substr($avatar, 0, 1) != '/' && substr($avatar, 0, 4) != 'http') {
            $avatar = config('upload.avatar.url').$avatar;
        }

        return redirect($avatar);
    }
}
