<?php

namespace Modules\Base\Events;

use Illuminate\Queue\SerializesModels;
use Modules\Base\Entities\File;

class FileUploaded
{
    use SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(File $file)
    {
        $this->file = $file;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }
}
