<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOpenidsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('openids', function (Blueprint $table) {
            $table->increments('id');
            $table->string('type')->index();
            $table->string('openid')->index();
            $table->string('unionid', 50)->index()->nullable()->comment('唯一ID');
            $table->integer('user_id');
            $table->unique(['type', 'openid']);
            $table->json('extra')->nullable()->comment('额外信息');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('openids');
    }
}
