@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Dashboard</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    已登陆
                        <br />

                    @if(Auth::user()->seller)
                        @switch(Auth::user()->seller->status)
                        @case(1)
                        卖家申请审核中
                        @break
                        @case(2)
                        <a href="{{route('seller.admin.home')}}">卖家后台</a>
                        @break
                        @case(3)
                        卖家申请已拒绝: {{Auth::user()->seller->refuse_info}}
                        @break
                        @case(4)
                        卖家账号已被禁用: {{Auth::user()->seller->refuse_info}}
                        @break
                        @endswitch
                    @else
                        <a href="{{route('register_seller')}}">注册成卖家</a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
