@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Register') }}</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('register') }}?{{$_SERVER['QUERY_STRING']}}" aria-label="{{ __('Register') }}">
                        @csrf

                        <div class="form-group row">
                            <label for="phone" class="col-4 col-md-4 col-form-label text-md-right">手机号</label>

                            <div class="col-8 col-md-6">
                                <input id="phone" type="text" class="form-control{{ $errors->has('phone') ? ' is-invalid' : '' }}" name="phone" value="{{ old('phone') }}" required autofocus>

                                @if ($errors->has('phone'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="captcha" class="col-4 col-md-4 col-form-label text-md-right">图形验证码</label>

                            <div class="col-3  col-md-3">
                                <input id="captcha" type="text" class="form-control" name="captcha" value="" required>
                            </div>
                            <div class="col-4 col-md-3">
                                <img src="/captcha" id="captcha_img" onclick="this.src='/captcha?r='+Math.random()" style="cursor: pointer" />
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="code" class="col-4 col-md-4 col-form-label text-md-right">手机验证码</label>

                            <div class="col-3 col-md-3">
                                <input id="code" type="text" class="form-control{{ $errors->has('code') ? ' is-invalid' : '' }}" name="code" value="{{ old('code') }}" required>

                                @if ($errors->has('code'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('code') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="col-3  col-md-3">
                                <button type="button" class="btn btn-primary" id="send_code">发送验证码</button>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password" class="col-4 col-md-4 col-form-label text-md-right">{{ __('Password') }}</label>

                            <div class="col-8 col-md-6">
                                <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required>

                                @if ($errors->has('password'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password-confirm" class="col-4 col-md-4 col-form-label text-md-right">{{ __('Confirm Password') }}</label>

                            <div class="col-8 col-md-6">
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Register') }}
                                </button>
                            </div>
                        </div>
                        <div class="form-group row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <a href="/download">已注册？点此打开APP登陆</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ asset('script/register.js') }}" defer></script>
@endsection
