<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/15
 * Time: 9:47
 */
namespace Modules\Base\Transformers;

use Modules\Base\Entities\File;

class FileTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="文件信息",
     *     type="object",
     *     schema="File",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="文件名"),
     *     @OA\Property(property="path", type="string", description="文件路径"),
     *     @OA\Property(property="mime", type="string", description="MIME类型"),
     *     @OA\Property(property="type", type="string", description="文件类型"),
     *     @OA\Property(property="url", type="string", description="访问URL"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(File $file)
    {
        return map_attr($file, [
            'id', 'name', 'path', 'type', 'mime', 'created_at', 'updated_at',
            'url' => get_file_url($file->path, $file->type),
        ]);
    }
}
