<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Base\Transformers;

use Illuminate\Notifications\DatabaseNotification;
use Illuminate\Support\Carbon;
use SMG\Page\PageModel;

class AnnouncementTransformer extends BaseTransformer
{
    protected $last_read_at;

    public function __construct($last_read_at)
    {
        parent::__construct();

        if (is_string($last_read_at)) {
            $last_read_at = Carbon::parse($last_read_at);
        }

        $this->last_read_at = $last_read_at;
    }

    /**
     * @OA\Schema(
     *     description="系统公告信息",
     *     type="object",
     *     schema="Announcement",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="type", type="string", description="通知类型"),
     *     @OA\Property(property="title", type="object", description="通知标题"),
     *     @OA\Property(property="content", type="object", description="通知内容"),
     *     @OA\Property(property="is_read", type="string", description="是否已查看"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(PageModel $table)
    {
        $fields =  map_attr($table, ['id', 'title', 'img', 'content', 'click', 'created_at', 'introduce', 'author', 'flag1', 'flag2', 'flag3', 'flag4']);

        $last_read_at = $this->last_read_at;

        if ($last_read_at->gt($table->created_at)) {
            $fields['is_read'] = true;
        } else {
            $fields['is_read'] = false;
        }

        return $fields;
    }
}
