<?php

\Route::get('/help/enum', '\Modules\Base\Http\Controllers\HelpController@showEnumList');

\Route::get('/download', '\Modules\Base\Http\Controllers\DownloadController@download');
\Route::get('/upload_apk', '\Modules\Base\Http\Controllers\DownloadController@upload')->middleware('web');
\Route::post('/upload_apk', '\Modules\Base\Http\Controllers\DownloadController@saveApk')->middleware('web');

\Route::get('user/{user}/avatar', '\Modules\Base\Http\Controllers\UserAvatarController@avatar');

//使用微信网页登陆的路由
Route::group([
    'prefix' => 'base',
    //'middleware' => ['web'],
    'middleware' => ['web', '\Overtrue\LaravelWeChat\Middleware\OAuthAuthenticate:snsapi_userinfo'],
    'namespace' => 'Modules\Base\Http\Controllers',
], function ($router) {

    //微信登陆并添加TOKEN后跳至返回页
    $router->get('/user/wechat_login', 'UserController@wechatLogin');
    $router->get('/user/wechat_bind', 'UserController@wechatBind');
});

\Route::get('/user/wechat_login_test', '\Modules\Base\Http\Controllers\UserController@wechatLoginTest');

$api = app('Dingo\Api\Routing\Router');

$api->version(
    'v1',
    array_merge(
        [
            'namespace' => 'Modules\Base\Http\Controllers\Api',
            'prefix' => 'api/base',
        ],
        config('api.defaultSetting', [])
    ),
    function ($api) {
        $api->get('/', 'ApiController@index')->name('api.base.home');

        // 短信验证码
        $api->post('sms', 'SmsController@store')
            ->name('api.base.sms.store');

        // 用户注册
        $api->post('users', 'UsersController@store')
            ->name('api.base.users.store');

        // 登录
        $api->post('authorizations', 'AuthorizationsController@store')
            ->name('api.base.authorizations.store');

        // 短信登录
        $api->post('authorizations/sms', 'AuthorizationsController@smsLogin')
            ->name('api.base.authorizations.sms');

        // 第三方账号登录
        $api->post('authorizations/openlogin/{type}', 'AuthorizationsController@openlogin')
            ->name('api.base.authorizations.openlogin');

        //短信重置密码
        $api->put('user/password', 'UsersController@password')
            ->name('api.base.user.password');

        // 需要 token 验证的接口
        $api->group(['middleware' => 'api.auth'], function ($api) {

            // 刷新token
            $api->put('authorizations/current', 'AuthorizationsController@update')
                ->name('api.base.authorizations.update');

            // 删除token
            $api->delete('authorizations/current', 'AuthorizationsController@destroy')
                ->name('api.base.authorizations.destroy');

            // 文件上传
            $api->post('files', 'FilesController@store')
                ->name('api.base.files.store');

            // 当前登录用户信息
            $api->get('user', 'UsersController@me')
                ->name('api.base.user.show');

            // 编辑登录用户信息
            $api->put('user', 'UsersController@update')
                ->name('api.base.user.update');

            // 根据手机号搜索用户
            $api->get('user_search/{phone}', 'UsersController@search')
                ->name('api.base.user.search');

            // 通知列表
            $api->get('user/notifications', 'NotificationsController@index')
                ->name('api.base.user.notifications.index');

            // 查看某一条通知
            $api->get('user/notifications/{notification_id}', 'NotificationsController@show')
                ->name('api.base.user.notifications.show');

            //发送一个测试的通知消息
            $api->post('user/notifications', 'NotificationsController@test')
                ->name('api.base.user.notifications.test');

            // 通知统计
            $api->get('user/notification_stats', 'NotificationsController@stats')
                ->name('api.base.user.notifications.stats');

            // 标记消息通知为已读
            $api->put('user/read/notifications', 'NotificationsController@read')
                ->name('api.base.user.notifications.read');

                // 公告列表
            $api->get('user/announcements', 'NotificationsController@announcement')
            ->name('api.base.user.notifications.announcement');
        });
    }
);
