<?php

namespace Modules\Base\Http\Controllers\Api;

use Modules\Base\Http\Requests\SmsRequest;
use Modules\Base\Services\SmsService;

class SmsController extends ApiController
{
    /**
     * @OA\Post(
     *     tags={"基础接口"},
     *     summary="发送短信验证码",
     *     path="/api/base/sms",
     *     description="type:手机验证码类型：1:注册，2:找回密码，3:更换手机号, 4:添加银行卡, 5:设置支付密码",
     *     @OA\RequestBody(
     *         required=true,
     *         description="xxxyy",
     *         @OA\MediaType(
     *             mediaType="application/x-www-form-urlencoded",
     *             @OA\Schema(
     *                 type="object",
     *                 required={"captcha_key"},
     *                 @OA\Property(
     *                     property="captcha_key",
     *                     type="string",
     *                     description="验证码KEY",
     *                 ),
     *                 @OA\Property(
     *                     property="captcha_code",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     property="phone",
     *                     type="string",
     *                 ),
     *                 @OA\Property(
     *                     type="integer",
     *                     property="type",
     *                     description="手机短信类型",
     *                     enum={1,2,3,4,5}
     *                 ),
     *             )
     *         )
     *     ),
     *     @OA\Response(response="201", description="发送成功")
     * )
     */
    public function store(SmsRequest $request, SmsService $sms)
    {
        $sms->send($request->phone, $request->type);

        return $this->response->noContent()->setStatusCode(201);
    }
}
