<?php
namespace Modules\Base\Http\Controllers\Api;

use Illuminate\Pagination\AbstractPaginator;
use Illuminate\Pagination\LengthAwarePaginator;
use Modules\Base\Http\Controllers\BaseController;
use Modules\Base\Transformers\CommonTransformer;
use Modules\Base\Transformers\BaseTransformer;

class ApiController extends BaseController
{
    use \Dingo\Api\Routing\Helpers;

    public function paginator(AbstractPaginator $list, BaseTransformer $transform)
    {
        if ($list instanceof LengthAwarePaginator) {
            return $this->response->paginator($list, $transform);
        }

        return $this->response->collection($list->getCollection(), $transform)
            ->setMeta(['pagination' => ['per_page' => $list->perPage(), 'current_page' => $list->currentPage(), 'count' => $list->count()]]);
    }

    public function emptyObject()
    {
        return $this->response->array(['data' => new \stdClass()]);
    }

    public function emptyPageData()
    {
        return $this->response->paginator(new LengthAwarePaginator(collect(), 0, request('per_page', 20)), new CommonTransformer());
    }
}
