<?php

namespace Modules\Base\Entities;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Arr;
use SMG\Support\Traits\Macroable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use Notifiable, Macroable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'avatar', 'ext', 'phone', 'sex',
    ];

    protected $casts = [
        'ext' => 'array',
        'is_blocked' => 'boolean',
    ];

    protected $appends = ['openid', 'display_name', 'admin_show_name'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [
            'last_login_time'=> $this->getExt('last_login_time'),
        ];
    }

    public  function apiLoginAndGetTokenInfo()
    {
        $auth = \Auth::guard('api');
        $this->saveExt(['last_login_time'=> date("Y-m-d H:i:s")]);

        return [
            'access_token' => $auth->login($this),
            'token_type' => 'Bearer',
            'expires_in' => $auth->factory()->getTTL() * 60,
        ];
    }

    public function saveExt($ext = [])
    {
        $old = $this->ext ?? [];

        $this->ext = array_merge($old, $ext);

        $this->save();
    }

    public function getExt($key, $default = null)
    {
        $ext = $this->ext ?? [];

        return Arr::get($ext, $key, $default);
    }

    public function getOpenidAttribute()
    {
        if (!is_array($this->ext)) {
            return null;
        }

        $openid_type = request('openid_type', false);

        if ($openid_type) {
            return $this->ext[$openid_type.'_openid'] ?? null;
        }

        foreach ($this->ext as $key => $one) {
            if (substr($key, -7) == '_openid') {
                return $one;
            }
        }

        return null;
    }

    public function getShowName2Attribute()
    {
        if ($this->name) {
            return $this->name;
        }

        $phone = $this->phone;

        return substr($phone, 0, 3).'****'.substr($phone, 7);
    }

    public function getShowNameAttribute()
    {
        return $this->name ?? $this->phone;
    }

    public function getAdminShowNameAttribute()
    {
        return $this->name ? $this->name.'('.$this->phone.')' : $this->phone;
    }

    public function getDisplayNameAttribute()
    {
        return $this->name ?? $this->phone;
    }
}
