<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExtInfoToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('avatar')->nullable()->comment('用户头像');
            //$table->string('introduction')->nullable()->comment('用户说明');
            $table->string('phone')->nullable()->unique()->after('name')->comment('用户手机号');
            $table->string('email')->nullable()->change();
            $table->string('name')->nullable()->change();
            $table->tinyInteger('sex')->default(0)->comment('性别');
            $table->unsignedInteger('level')->default(0)->comment('等级');
            $table->boolean('is_blocked')->default(0)->comment('是否停用');
            $table->dateTime('system_notice_lastest_read_at')->default("2019-12-06 00:00:00")->comment('系统消息最近查看时间');
            $table->json('ext')->nullable()->comment('用户扩展信息');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('avatar');
            //$table->dropColumn('introduction');
            $table->dropColumn('phone');
            $table->dropColumn('sex');
            $table->string('email')->nullable(false)->change();
            $table->string('name')->nullable(false)->change();
        });
    }
}
