<?php

use Encore\Admin\Auth\Database\Menu;
use Illuminate\Database\Migrations\Migration;

class ImportMenu0414122047 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        $parent_id =  0;
        $menu = $this->createMenu('方案管理', NULL, 'fa-bars', $parent_id);
        $parent_id=$menu->id;


        $this->createMenu('方案列表', 'scheme', 'fa-bars', $parent_id);
        $this->createMenu('方案配置', 'scheme_config', 'fa-bars', $parent_id);

        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    /**
     * 创建菜单
     *
     * @param $title
     * @param $uri
     * @param string $icon
     * @param int    $parentId
     *
     * @return mixed
     */
    protected function createMenu($title, $uri, $icon = 'fa-bars', $parentId = 0)
    {
        $lastOrder = Menu::max('order');

        return Menu::create([
            'parent_id' => $parentId,
            'order' => $lastOrder + 1,
            'title' => $title,
            'icon' => $icon,
            'uri' => $uri,
        ]);
    }

    /**
     * 创建权限
     *
     * @param $name
     * @param $slug
     * @param $path
     * @param null $http_method
     */
    protected function createPermission($name, $slug, $path, $http_method = null)
    {
        \Encore\Admin\Auth\Database\Permission::create([
            'name' => $name,
            'slug' => $slug,
            'http_path' => '/'.trim($path, '/'),
            'http_method' => $http_method,
        ]);
    }
}
