<?php

$default_filesystem = "admin";
$url = "/uploads/";

return [
    'file' => [
        "validate" => 'mimes:jpeg,jpg,bmp,png,gif,txt,doc,docs,xsl,xsls,ppt,ppts',
        "validate_msg" => [],
        "folder" => "file",
        "filesystem" => "local",//使用的储存系统
    ],
    'image' => [
        "validate" => 'mimes:jpeg,jpg,bmp,png,gif,txt,doc,docs,xsl,xsls,ppt,ppts',
        "validate_msg" => [],
        "folder" => "image",
        "filesystem" => $default_filesystem,//使用的储存系统
        "url" => $url,
        'image_processor' => 'resize:2000,2000,constraint=aspectRatio',
    ],
    'avatar' => [
        "validate" => 'mimes:jpeg,jpg,bmp,png,gif|dimensions:min_width=200,min_height=200',
        "validate_msg" => [],
        "folder" => "avatar",
        "filesystem" => $default_filesystem,//使用的储存系统
        "url" => $url,
        'image_processor' => 'resize:200,null,constraint=aspectRatio&upsize|crop:200,200',
    ],


    'comment' => [
        "validate" => 'mimes:jpeg,jpg,bmp,png,gif|dimensions:max_width=20000,max_height=20000',
        "validate_msg" => [],
        "folder" => "comment",
        "filesystem" => $default_filesystem,//使用的储存系统
        "url" => $url,
        'image_processor' => 'resize:2000,2000,constraint=aspectRatio',
    ],

    'seller' => [
        "validate" => 'mimes:jpeg,jpg,bmp,png,gif|dimensions:max_width=20000,max_height=20000',
        "validate_msg" => [],
        "folder" => "seller",
        "filesystem" => $default_filesystem,//使用的储存系统
        "url" => $url,
    ],

    'video' => [
        "validate" => 'mimes:mp4',
        "validate_msg" => [],
        "folder" => "video",
        "filesystem" => $default_filesystem,//使用的储存系统
        "url" => $url,
    ],
];