<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Share\Transformers;

use Modules\Share\Entities\SchemeConfig;

class SchemeConfigTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="方案列表",
     *     type="object",
     *     schema="SchemeConfig",
     *     @OA\Property(property="introduce_manager_ratio", type="integer", description="介绍掌柜奖励比例"),
     *     @OA\Property(property="default_manager_ratio", type="integer", description="默认奖励比例"),
     * )
     */
    public function transform(SchemeConfig $schemeConfig)
    {
        return map_attr($schemeConfig, ['introduce_manager_ratio', 'default_manager_ratio']);
    }
}
